require( "quest/m1_spendalot1/convout.lua" );
combine_speech_tables();

flo_anim_table =
{
	"anim/flo/stands", "anim/flo/standse", "anim/flo/talksegestures",
	"anim/flo/talks",
	"anim/flo/talkse",
	"anim/flo/walke",
	"anim/flo/walkn",
	"anim/flo/walkne",
	"anim/flo/walks",
	"anim/flo/walkse",
};

flo_spec =
{
	name = "FLO";
	halo = "quest/objects/flo";
	anim = flo_anim_table;
	cantuse = "obj_flo_cantuse";
	
	command = function(actor)
		prepare_actor_text(actor, flo_text_spec);
 
		--actor:AddFlag(AFLAG.AFLAG_USE_LIGHTMAP);	-- enable ground-based lighting
		actor:AddFlag(AFLAG.AFLAG_X_FLIPPABLE);
		actor:SetDepthMode(DEPTH.DEPTH_BY_Y);		-- depth by y
		actor:AddFlag(AFLAG.AFLAG_IGNORE_GROUND_MESH);
		actor:AddFlag(AFLAG.AFLAG_NO_GROUND_CLICKS);
		actor:AddFlag(AFLAG.AFLAG_SCALE_BY_Y);	-- enable ground-based scaling
		actor:SetWalkSpeed(flo_speed);
		
		if game:GetLastScene() == "m1_intersection" then
			actor:FaceNow(DIR.W);
			actor:JumpToNamedPoint("flo_intersection");
			scene:SetCameraFollowActor(actor);
			scene.CAMERA:JumpToNamedPoint("flo_east");
			actor:WalkTo("flo_east");
			game:SetString("map_position", "m1_subway");
		elseif game:GetLastScene() == "subway" then
			actor:Face(DIR.S);
			actor:JumpToNamedPoint("to_subway");
			actor:WalkTo("flo_east");
			game:SetString("map_position", "m1_subway");
		else -- pet shop
			scene.DOOR:PlayAnim("Opened");
			actor:Face(DIR.S);
			actor:JumpToNamedPoint("petshop");
			actor:WalkTo("flo_west");
			delay(3);
			scene.DOOR:PlayAnim("Close");
			game:SetString("map_position", "m1_petshop");
			spawn_nav_arrow(door_petshop_spec);
		end
		
		if game:Get("first_time_m1_spendalot1") < 1 then
			game:Set("first_time_m1_spendalot1", 1);
		end
		
		wait_walkto();
		actor:Face(DIR.S);
		
		scene:SetCameraFollowActor(scene.CAMERA);
		actor:ClearFlag(AFLAG.AFLAG_IGNORE_GROUND_MESH);
		actor:SetMode(MODE.FOLLOWCLICKS);
	end;
	
	on_arrive = function(flo1, flo2)
		convproc("FLO", "quip_flo_general");
	end;
	
	on_use_inv = function(item, flo, flo2)
		flo_inv_generic(flo, item);
		return RESPONSE.INV_HANDLED;
	end;
};

ethel_anim_table =
{
	"anim/ethel/stand",
	"anim/ethel/talke",
};

function ethel_conv(flo)
	flo:SetMode(MODE.CUTSCENE);
	
	if game:Get("talked_to_ethel") < 1 then
		run_super_conversation(flo, "conv_ethel_intro");
		game:Set("talked_to_ethel", 1);
		
		if game:Get("asked_ethel_for_beads") == 1 then		
			if game:Get("given_ethel_wire_cutters") == 1 then
				game:Set("got_beads_from_ethel", 1);
				complete_quest("give_ethel_wirecutters", false);
				complete_quest("need_beads", false);
				add_quest("finish_beading");
			elseif BAG_INV:CheckInventory("wirecutters") then
				if not quest_complete("need_wirecutters") then
					complete_quest("need_wirecutters", false);
					add_quest("give_ethel_wirecutters");
				elseif not quest_added("give_ethel_wirecutters") then
					add_quest("give_ethel_wirecutters");
				end
			elseif not quest_added("need_wirecutters") then
				add_quest("need_wirecutters");
			end
		end
		
	elseif game:Get("mg_bead_activity_round") < 2 then
		run_super_conversation(flo, "conv_ethel_rings");
	elseif game:Get("mg_bead_activity_round") < 3 and game:Get("got_beads_from_ethel") < 1 then
		if game:Get("asked_ethel_for_beads") < 1 and BAG_INV:CheckInventory("wirecutters") == false then
			run_super_conversation(flo, "conv_ethel_introb");
			game:Set("asked_ethel_for_beads", 1);
			--if BAG_INV:CheckInventory("wirecutters") then
			--	complete_quest("need_wirecutters", false);
			--	add_quest("give_ethel_wirecutters");
			--else
			--	add_quest("need_wirecutters");
			--end;
			
			if game:Get("given_ethel_wire_cutters") == 1 then
				game:Set("got_beads_from_ethel", 1);
				complete_quest("give_ethel_wirecutters", false);
				complete_quest("need_beads", false);
				add_quest("finish_beading");
			else
				add_quest("need_wirecutters");
			end
		elseif BAG_INV:CheckInventory("wirecutters") then
			game:Set("asked_ethel_for_beads", 1);
			
			if not quest_complete("need_wirecutters") then
				complete_quest("need_wirecutters", false);
				add_quest("give_ethel_wirecutters");
			elseif not quest_added("give_ethel_wirecutters") then
				add_quest("give_ethel_wirecutters");
			end
			run_super_conversation(flo, "conv_ethel_have_cutters");
		else
			run_super_conversation(flo, "conv_ethel_need_cutters");
		end
	else
		run_super_conversation(flo, "conv_ethel_done");
	end
		
	flo:SetMode(MODE.FOLLOWCLICKS);
end

function give_ethel_wire_cutters(flo)
	flo:SetMode(MODE.CUTSCNE);
	BAG_INV:RemoveInventory("wirecutters");
	game:Set("given_ethel_wire_cutters", 1);
	
	if game:Get("asked_ethel_for_beads") < 1 then
		run_super_conversation(flo, "conv_ethel_give_cutters_alt");
	else
		run_super_conversation(flo, "conv_ethel_give_cutters");
		game:Set("got_beads_from_ethel", 1);
		complete_quest("give_ethel_wirecutters", false);
		complete_quest("need_beads", false);
		add_quest("finish_beading");
	end
	
	flo:SetMode(MODE.FOLLOWCLICKS);
end

ethel_spec = 
{
	name = "ETHEL";
	halo = "quest/objects/ethel";
	anim = ethel_anim_table;
	
	command = function(actor)
		prepare_actor_text(actor, ethel_text_spec);
 
		--actor:AddFlag(AFLAG.AFLAG_USE_LIGHTMAP);	-- enable ground-based lighting
		actor:AddFlag(AFLAG.AFLAG_X_FLIPPABLE);
		actor:SetDepthMode(DEPTH.DEPTH_BY_Y);		-- depth by y
		actor:SetWalkSpeed(ethel_speed);
		actor:JumpToNamedPoint("ethel");
		actor:FaceNow(DIR.E);
	end;
	
	on_arrive = function(flo, ethel)
		flo:FaceActor(ethel);
		flo:StartProc(ethel_conv);
	end;
	
	on_use_inv = function(item, flo, ethel)
		flo:FaceActor(ethel);
		if item == "wirecutters" then
			flo:StartProc(give_ethel_wire_cutters);
			return RESPONSE.INV_HANDLED;
		else
			return RESPONSE.INV_UNHANDLED;
		end
	end;
};

function gotointersection(flo)
	flo:SetMode(MODE.CUTSCENE);
	flo:AddFlag(AFLAG.AFLAG_IGNORE_GROUND_MESH);
	scene:SetCameraFollowActor(scene.FLO);
	flo:WalkTo("to_intersection");
	delay(150);
	goto_scene(flo, "m1_intersection", true);
end

to_intersection_spec = 
{
	name = "TO_INTERSECTION";
	halo = "to_intersection";
	cursor = "cursor_arrow_e";
	goto_fn = gotointersection;
}

function gotospendalotwest(flo)
	flo:SetMode(MODE.CUTSCENE);
	flo:AddFlag(AFLAG.AFLAG_IGNORE_GROUND_MESH);
	scene:SetCameraFollowActor(scene.FLO);
	flo:WalkTo("flo_west");
	wait_walkto();
	flo:Face(DIR.S);
	
	flo:ClearFlag(AFLAG.AFLAG_IGNORE_GROUND_MESH);
	scene.CAMERA:JumpToNamedPoint("flo_west");
	scene:SetCameraFollowActor(scene.CAMERA);
	spawn_nav_arrow(door_petshop_spec);
	flo:SetMode(MODE.FOLLOWCLICKS);
	game:SetString("map_position", "m1_petshop");
end

to_spendalotwest_spec = 
{
	name = "TO_SPENDALOTWEST";
	halo = "to_spendalotwest";
	cursor = "cursor_arrow_w";
	goto_fn = gotospendalotwest;
}

function gotospendaloteast(flo)
	flo:SetMode(MODE.CUTSCENE);
	scene.DOOR_PETSHOP:Expire();
	flo:AddFlag(AFLAG.AFLAG_IGNORE_GROUND_MESH);
	scene:SetCameraFollowActor(scene.FLO);
	flo:WalkTo("flo_east");
	wait_walkto();
	flo:Face(DIR.S);
	
	flo:ClearFlag(AFLAG.AFLAG_IGNORE_GROUND_MESH);
	scene.CAMERA:JumpToNamedPoint("camera_spendalot1");
	scene:SetCameraFollowActor(scene.CAMERA);
	flo:SetMode(MODE.FOLLOWCLICKS);
	game:SetString("map_position", "m1_subway");
end

to_spendaloteast_spec = 
{
	name = "TO_SPENDALOTEAST";
	halo = "to_spendaloteast";
	cursor = "cursor_arrow_e";
	depth = 600;
	goto_fn = gotospendaloteast;
}

function gotopetshop(flo)
	flo:SetMode(MODE.CUTSCENE);
	if game:Get("module_progress") < 3 then
		flo:AddFlag(AFLAG.AFLAG_IGNORE_GROUND_MESH);
		flo:WalkTo("petshop");
		delay(30);
		
		goto_scene(flo, "m1_petshop");
	else
		run_super_conversation(flo, "quip_shop_closed");
		flo:SetMode(MODE.FOLLOWCLICKS);
	end
end

door_petshop_spec = 
{
	name = "DOOR_PETSHOP";
	halo = "door_petshop";
	cursor = "cursor_arrow_n";
	goto_fn = gotopetshop;
	point_at_fn = function(actor, enter)
		if actor:GetMode() ~= MODE.CUTSCENE and game:Get("module_progress") < 3 then
			if enter then
				scene.DOOR:PlayAnim("Open");
			else
				scene.DOOR:PlayAnim("Close");
			end
		end
	end;
}

door_spec =
{
	name = "DOOR";
	gfx = {anim = "anim/m1_spendalot1/door"};
	
	command = function(actor)
		actor:PlayAnim("Closed");
		actor:SetDepthValue("1");
	end;
}

laundry_spec =
{
	name = "WASHING";
	gfx = {anim = "anim/m1_spendalot1/laundry"};
	halo = "laundry";
	
	command = function(actor)
		actor:SetDepthValue("1");
		actor:AddFlag(AFLAG.AFLAG_SPECIAL_ANIM);
		while true do
			actor:PlayAnim("Blow");
			wait_anim();
			delay(math.random(120,180));
		end
	end;
	
	on_arrive = function(actor)
		convproc("FLO", "backup_quip_street_laundry");
	end;
};

function goto_subway(flo)
	flo:SetMode(MODE.CUTSCENE);
	flo:AddFlag(AFLAG.AFLAG_IGNORE_GROUND_MESH);
	flo:WalkTo("to_subway");
	delay(30);
	
	goto_scene(flo, "subway");
end

to_subway_spec = 
{
	name = "TO_SUBWAY";
	halo = "to_subway";
	cursor = "cursor_arrow_s";
	goto_fn = goto_subway;
}

function use_recycle_machine(flo)
	flo:SetMode(MODE.CUTSCENE);
	flo:WalkTo("recyclemachine");
	wait_walkto();
	
	flo:FaceActor(actor);
	delay(30);
	
	scene:ChainToSubScene("recyclemachine");
	wait_subscene();
	
	flo:WalkTo("flo_east");
	wait_walkto();
	flo:Face(DIR.S);
	
	flo:SetMode(MODE.FOLLOWCLICKS);
end

recyclemachine_spec = 
{
	name = "RECYCLE_MACHINE";
	halo = "recyclemachine";
	gfx = { image = "recyclemachine" };
	
	command = function(actor)
		actor:SetDepthValue(200);
	end;
	
	on_arrive = function(flo, actor)
		flo:FaceActor(actor);
		flo:StartProc(use_recycle_machine);
	end;
	
	on_use_inv = function(item, flo, actor)
		if item == "recyclable" then
			flo:StartProc(use_recycle_machine);
			return RESPONSE.INV_HANDLED;
		else
			return RESPONSE.INV_UNHANDLED;
		end
	end;
}

jewelry_stand_spec = 
{
	name = "JEWELRY_SPEC";
	gfx = { image = "jewelry_stand" };
	
	command = function(actor)
		actor:SetDepthValue(405);
		--actor:SetDepthMode(DEPTH.DEPTH_BY_Y);
	end;
}

subway_sign_spec = 
{
	name = "SUBWAY_SIGN";
	
	command = function(actor)
		actor:SetDepthValue(500);
		actor:ModifySaySpec
		{
			font = "fonts/hobo_std.mvec",
			color = { a = 1, r = 0.76, g = 0.21, b = 0.27 },
			outline_size = 0,
			lineheight = 28,
			linepadding = 2,
		}
		
		actor:SetAlpha(0.8);
		
		actor:Say("text_subway_sign");
		actor:StopWalking();
		actor:SetPolygon({x=1365,y=173}, {x=1475,y=173}, {x=1365,y=210}, {x=1475,y=210});
		actor:TextToImage(10, 0);
	end;
}

pet_shop_sign_spec = 
{
	name = "PET_SHOP_SIGN";
	
	command = function(actor)
		actor:SetDepthValue(500);
		actor:ModifySaySpec
		{
			font = "fonts/dorchester_script_mt_std.mvec",
			color = { a = 1, r = 0.99, g = 0.97, b = 0.65 },
			outline_size = 0,
			lineheight = 45,
			linepadding = -11,
		}
		
		actor:SetAlpha(0.7);
		
		actor:Say("text_pet_shop_sign");
		actor:StopWalking();
		actor:SetPolygon({x=582,y=182}, {x=652,y=182}, {x=582,y=232}, {x=652,y=232});
		actor:TextToImage(0, 0);
	end;
}

spendalot_ave_sign_spec = 
{
	name = "SPENDALOT_AVE_SIGN";
	
	command = function(actor)
		actor:SetDepthValue(500);
		actor:ModifySaySpec
		{
			font = "fonts/helvetica_rounded_lt_std_blk.mvec",
			color = { a = 1, r = 1, g = 1, b = 1 },
			outline_size = 0,
			lineheight = 23,
		}
		
		actor:Say("text_spendalot_ave_sign");
		actor:StopWalking();
		actor:SetPolygon({x=91,y=165}, {x=215,y=165}, {x=91,y=182}, {x=215,y=182});
		actor:TextToImage(6, 0);
	end;
}

other_street_sign_spec = 
{
	name = "OTHER_STREET_SIGN";
	
	command = function(actor)
		actor:SetDepthValue(500);
		actor:ModifySaySpec
		{
			font = "fonts/helvetica_rounded_lt_std_blk.mvec",
			color = { a = 1, r = 1, g = 1, b = 1 },
			outline_size = 0,
			lineheight = 21,
		}
		
		actor:Say("text_other_street_sign");
		actor:StopWalking();
		actor:SetPolygon({x=10,y=203}, {x=67,y=168}, {x=15,y=221}, {x=68,y=186});
		actor:TextToImage(0, 0);
	end;
}

camera_spec = 
{
	name = "CAMERA";
	command = function(actor)

		actor:AddFlag(AFLAG.AFLAG_IGNORE_GROUND_MESH);
		actor:SetWalkSpeed(6);
		
		if game:GetLastScene() == "m1_intersection" then
			actor:JumpToNamedPoint("flo_intersection");
		elseif game:GetLastScene() == "subway" then
			actor:JumpToNamedPoint("flo_east");
		else -- pet shop
			actor:JumpToNamedPoint("flo_west");
		end
	end;
};

bird_spec = 
{
	name = "BIRD_SPEC";
	gfx = { anim = "anim/m1_spendalot1/bird" };
	halo = "bird";
	
	command = function(actor)
		actor:AddFlag(AFLAG.AFLAG_SPECIAL_ANIM);
		actor:SetDepthValue(601);
		actor.animating = false;
		actor:PlayAnim("Rest");
	end;

	on_arrive = function(flo, actor)
		convproc("FLO", "backup_quip_street_bird");
		if actor.animating == false then
			actor:StartProc(function(actor)
				actor:DumpZone();
				actor:PlayAnim("Idle");
				actor.animating = true;
				wait_anim();
				actor.animating = false;
				actor:LoadZone("quest/m1_spendalot1/bird");
			end);
		end
	end;
};

scene_setup =
{
	name = "SETUP",
	command = function(actor)
		if IsCheatMode() then
			-- testing data
			--game:Set("got_butterflybag", 1);
			--game:Set("got_napkin", 1);
			--game:Set("found_phone", 1);
			--game:Set("first_time_diner", 1);
			--game:Set("cleaned_coffee_spill", 1);
			--game:Set("diner_phone_ringing" , 1);
			
			--game:Set("mg_bead_activity_round", 2);
			--BAG_INV:AddInventory(inv_desc_wirecutters);
			--BAG_INV:AddInventory(inv_desc_beads);
		end
		
		spawn_nav_arrow(to_intersection_spec);
		spawn_nav_arrow(to_spendalotwest_spec);
		spawn_nav_arrow(to_spendaloteast_spec);		
		spawn_nav_arrow(to_subway_spec);
		
		sfx:SetMusic("audio/music/walkingmusic.ogg", true);
		sfx:PlaySFX("audio/sfx/ambient_mod1.ogg", true);
		scene:SetRoomScale(300, 550, 0.6, 0.8);	--topline, bottomline, topscale, bottomscale
		
		local no_fade = game:GetLastScene() == "m1_intersection";
		fade_scene_up(false, no_fade);
		
		scene:SetCameraFollowActor(scene.CAMERA);		-- Attach the camera to follow "CAMERA" actor
		scene:SetCameraMargin { x = 400, y = 300 };
		
		if game:Get("module_progress") < 3 then
			scene:Spawn(ethel_spec);
			scene:Spawn(jewelry_stand_spec);
		end
		
		spawn_simple_hotspot("end_of_street", 5);
	end;
};

scene_spec =
{
	atlas = 
	{
		"pieces", -- load pieces
	};
	
	bg_image = 
	{
		{ "background", DEPTH.DEPTH_BACKMOST  },
		
		{ "car", 500 },
		{ "truck", 430 },
		{ "hydrant1", 430 },
		{ "hydrant2", 430 },
		{ "lamp1", 429 },
		{ "lamp2", 429 },
		{ "lamp3", 429 },
		{ "van", 430 },
		
		--{ "objects", 5 },

		--{ "foreground", DEPTH.DEPTH_FRONTMOST },
	};
	
	--lightmap = "lightmap";	-- use the ground as the lightmap
	
	ground = "background";
	
	actorlist = 
	{ 
		camera_spec,
		scene_setup,
		door_spec,
		laundry_spec,
		
		flo_spec, -- the main actor
		
		recyclemachine_spec,
		subway_sign_spec,
		pet_shop_sign_spec,
		spendalot_ave_sign_spec,
		other_street_sign_spec,
		bird_spec,
	};
};
